function [x,data,k] = Port_Fix(objfun,Q,h,x0,alpha)

% Parameters
MAXITER   = 50;


% save iterate information
data    = [];
data.x0 = x0;
data.x  = []; % iterates
data.d  = []; % search directions
data.g  = []; % gradients
data.f  = []; %function value
data.a  = []; %stepsize

% initial iterate should be feasible
xk = project_simplex(x0);

% print the header
printIter();

tic
for k = 1:MAXITER
    
    % compute function and gradient
    [f_k,g_k] = objfun(xk);

    
    xk1 = project_simplex(xk-alpha*g_k);
    d_k = xk1-xk;
    
    
    % record the iterates
    if nargout >= 2
        data.x = [data.x,xk];
        data.d = [data.d,d_k];
        data.g = [data.g,g_k];
        data.f = [data.f;f_k];
        data.a = [data.a;alpha];
    end
    
    % update iterate
    xk = xk1;
    
    % print progress
    printIter(k, f_k, norm(d_k), alpha, toc);
    
    
end

x = xk;


end


function printIter(iter, f_k, d_k_norm, alpha_k, CPUtime)
% print the iteration progress

if nargin==0
% Store output header and footer strings as persistent variables
out_line = '================================================================================';
out_data = '   k       f     ||x^k - x^{k+1}||    alpha       CPU (s)';

% print algorithm output header
fprintf('\nBeginning gradient descent ...\n')
fprintf('%s\n%s\n%s\n', out_line, out_data, out_line)
return;
end

% Print iterate information
fprintf('% 4d  % .4e  % .4e    % .4e   % .5f\n',iter, f_k, d_k_norm, alpha_k, CPUtime);



end
